﻿#if UNITY_EDITOR
using UnityEngine;
using UnityEditor;
using System.IO;
using System.Collections.Generic;
using System;
using System.Collections;
using UnityEngine.Networking;

[InitializeOnLoad]
public class EditorUpdateTraductions
{
    [MenuItem("Zero One/Update Traduction")]
	static void UpdateTraductions()
	{
        GameObject go = new GameObject("UpdateTrad");

        go.name = "UpdateTrad";

        go.AddComponent<UpdateTraductionsObject>();
    }
}

[ExecuteInEditMode]
public class UpdateTraductionsObject : MonoBehaviour
{
    IEnumerator Start()
    {
        Debug.Log("Start Updating Traduction Now");

        List<Dictionary<string, string>> tradsKeys = new List<Dictionary<string, string>>();

		Dictionary<string, Dictionary<string, string>> saved = new();

        //int diff = 0;

        string url = "https://docs.google.com/spreadsheets/d/e/2PACX-1vTlx6a2-wf4pSl_QENJuIalhHY7tFomWPOnKZIfGZA7cq9bp2fTely7nf_inNjPHyO8q7YHAwNtbuwY/pub?gid=0&single=true&output=tsv";

        UnityWebRequest unityWebRequest = UnityWebRequest.Get(url);

        yield return unityWebRequest.SendWebRequest();

        if (unityWebRequest.result == UnityWebRequest.Result.ConnectionError)
        {
            EditorUtility.DisplayDialog("Traductions files", "Failed to download trad file", unityWebRequest.error);
        }
        else
        {
            string text = unityWebRequest.downloadHandler.text;

            string[] files = null;
            string[] langues = null;

            int tradKey = 0;
            int nbLanguages = 0;

            bool firstLine = true;
            string result = "";

            using (StringReader sr = new StringReader(text))
            {
                string line;
                while ((line = sr.ReadLine()) != null)
                {
                    if (line.StartsWith("#") || line.Length < 3)
                    {
                        continue;
                    }

                    string[] lineSplit = line.Split(new[] { '\t' });

                    if (firstLine)
                    {
                        firstLine = false;

                        nbLanguages = lineSplit.Length - 1;

                        files = new string[nbLanguages];
                        langues = new string[nbLanguages];

                        for (int i = 0; i < nbLanguages; i++)
                        {
                            langues[i] = lineSplit[i + 1];
                            if (string.IsNullOrEmpty(langues[i])) continue;

                            Local.traductions = new();
							Local.Init(langues[i]);

                            saved.Add(langues[i], Local.traductions);

                        }
                        continue;
                    }

                    for (int i = 0; i < nbLanguages; i++)
                    {
                        if (string.IsNullOrEmpty(langues[i])) continue;

                        if (lineSplit.Length > 2 && lineSplit[0].Length > 0)
                        {
                            string val = lineSplit[i + 1];

							if (!string.IsNullOrEmpty(val))
                            {

                                files[i] += lineSplit[0] + "=" + val + "\n";

                                var trads = saved[langues[i]];

                                var oldTrads = "";
                                trads.TryGetValue(lineSplit[0], out oldTrads);

                                if (oldTrads != null)
                                {
                                    oldTrads = oldTrads.Replace("\n", "\\n");
                                }

								if (oldTrads != lineSplit[i + 1])
                                {
                                    result += $"{oldTrads} => {val}\n";
									//Debug.Log($"Change {oldTrads} => {val}");
                                }

                                tradKey++;
                            }
                        }
                    }
                }
            }
#if IO_LOG
        Debug.Log("File.WriteAllText(" + "Assets/Resources/Local/English.txt" + ");");
#endif

            for (int i = 0; i < nbLanguages; i++)
            {
				if (string.IsNullOrEmpty(langues[i])) continue;

				File.WriteAllText("Assets/Resources/Local/" + langues[i] + ".txt", files[i]);
            }

            EditorUtility.DisplayDialog("Traductions files done", tradKey.ToString() + "\n-----------------------------------------------------------------------------------------\n" + result, "OK");

        }

        AssetDatabase.Refresh();

        // ephemer object
        DestroyImmediate(gameObject);
    }
}
#endif